Ext.define('Override.app.Decorator', {
    override: 'Ext.Decorator',

    updateComponent: function(newComponent, oldComponent)
    {
        var element = this.innerElement;

        if (oldComponent) {
            // Added check before removeChild call
            if (oldComponent.renderElement.dom) {
                element.dom.removeChild(oldComponent.renderElement.dom);
            }

            if (this.isRendered() && oldComponent.setRendered(false)) {
                oldComponent.fireEvent('renderedchange', oldComponent, false); 
            }
        }

        if (newComponent) {
            element.dom.appendChild(newComponent.renderElement.dom);

            if (this.isRendered() && newComponent.setRendered(true)) {
                newComponent.fireEvent('renderedchange', newComponent, true);
            }
        }
    }
});  